<?php

namespace App\Http\Controllers\CrmSiteFront;

use App\Http\Controllers\Controller;
use App\Models\Accessory;
use App\Models\Baner;
use App\Models\Category;
use App\Models\BestSeller;
use Illuminate\Http\Request;
class AccessoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categories = new Category();
        $categoriesInfo = $categories->all();

        $baners = Baner::whereType('home')->get();

        return view('CRM.SiteFront.CatBanners.accessories',compact('categoriesInfo','baners'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request = $request->all();
        unset($request['_token']);
        $accessories = new Accessory();
        foreach ($request as $key=>$value){
            if($value == 0){
                $accessories->updateOrCreate(
                    ['category_field_name' => $key],
                    [
                        'category_id' => Null,
                        'status' => 0
                    ]
                );
            }else{
                $accessories->updateOrCreate(
                    ['category_field_name' => $key],
                    [
                        'category_id' => $value,
                        'status' => 1
                    ]
                );

            }
        }
        $message = "بنر  با موفقیت بروزرسانی شد";
        $messageType = "success";
        session()->flash('message', $message);
        session()->flash('messageType', $messageType);
        return redirect(route('accessories.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
