<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Events\ResetPassEvent;
use App\Http\Controllers\Controller;
use App\Models\PasswordReset;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Event;

class ResetPasswordController extends Controller
{


    protected function sendSmsCode(){

        $user = User::whereId(Auth::id())->first();

        if(isset($user)){
            Event::fire(new ResetPassEvent($user));
        }
    }

    protected function showResetForm(Request $request){

        $this->validate($request, [
            'resetPassCode' => ['required','digits:5'],
        ]);

        $request = $request->all();

        $pass_reset = PasswordReset::where('user_id',Auth::id())->where('sms_code',$request['resetPassCode'])->first();

        if(isset($pass_reset)){

            return view('public.SiteFront.auth.passReset');

        }else{
            alert()->flash('خطا', 'error', [
                'text' => "کد وارد شده صحیح نمی باشد",
                'showConfirmButton' => false,
                'timer' => 1500
            ]);

        }
        return redirect()->back();
    }

    protected function reset(Request $request){

        $this->validate($request, [
            'password'=>'confirmed|required|max:60|min:6'
        ]);

        $user = User::whereId(Auth::id())->first();

        $user->update([
            'password' => bcrypt($request['password'])
        ]);

        $pass_reset = PasswordReset::where('user_id',Auth::id())->first();


        deleteSimple($pass_reset);

        alert()->flash('بروزرسانی شد', 'success', [
            'text' => "رمز عبور شما با موفقیت بروزرسانی شد، لطفا با رمز جدید وارد شوید",
            'showConfirmButton' => true,
        ]);

        Auth::logout();

        return redirect(route('login.show'));
    }
}
