<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Cart;
use App\Models\User;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Contracts\Cookie\Factory;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{

    public $decayMinutes = 3;
    public $maxAttempts = 7;


    use AuthenticatesUsers;

    public function showLoginForm()
    {
        if(!Auth::check()){
            return view('public.SiteFront.auth.login');
        }else{
            return redirect()->back();
        }

    }
    /**
     * Create a new controller instance.
     *
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    protected function redirectTo(){
        $user = User::whereId(Auth::id())->first();

        if(isset($user)){
            if($user->role == 'admin'){
                return '/CRM/Dashboard';
            }
        }
        return '/';
    }


    /**
     * Handle a login request to the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response|\Illuminate\Http\JsonResponse
     */
    public function login(Request $request)
    {
        $this->validateLogin($request);

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if ($this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        $user = User::where('mobile',$request->mobile)->first();
        if(isset($user)){
            if($user->confirmed == 1){
                if ($this->attemptLogin($request)) {
                    return $this->sendLoginResponse($request);
                }
            }else{
                alert()->flash('خطا!', 'error', ['text' => 'حساب کاربری شما فعال نگردیده است لطفا با درخواست کد فعال سازی آن را فعال کنید',
                    'type' => 'error',
                    'showConfirmButton' => true,
                ]);
                return redirect(url('/register/activation'));
            }
        }else{
            alert()->flash('خطا!', 'error', ['text' => 'چنین حساب کاربری وجود ندارد',
                'type' => 'error',
                'showConfirmButton' => true,

            ]);
            return redirect()->back();
        }


        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    protected function sendLockoutResponse(Request $request)
    {
        $seconds = $this->limiter()->availableIn(
            $this->throttleKey($request)
        );

        alert()->flash('خطا!', 'error', [
            'text' => "به دلیل تلاشهای ناموفق متعدد برای ورود، از ورود شما به مدت ". $seconds ." ثانیه جلوگیری می شود.",
            'type' => 'error',
            'showConfirmButton' => true,
            'confirmButtonText' => 'باشه',
        ]);
        return redirect()->back();

    }


    /**
     * Validate the user login request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return void
     */
    protected function validateLogin(Request $request)
    {
        $this->validate($request, [
            $this->username() => ['required','digits:11','regex:/^(0)?(9[0-9]{9})$/'],
            'password'=>'required|max:60'
        ]);

    }


    /**
     * Send the response after the user was authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    protected function sendLoginResponse(Request $request)
    {

        $request->session()->regenerate();

        $this->clearLoginAttempts($request);

        return $this->authenticated($request, $this->guard()->user()) ?: redirect()->intended($this->redirectPath());
    }

    /**
     * The user has been authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function authenticated(Request $request, $user)
    {
        alert()->flash('خوش آمدید', 'success', [
            'text' => "از خرید خود لذت ببرید",
            'showConfirmButton' => false,
            'timer' => 2000
        ]);
        Cart::addToCartInLogin();
    }

    /**
     * Get the failed login response instance.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\Response
     *
     * @throws ValidationException
     */
    protected function sendFailedLoginResponse(Request $request)
    {
        alert()->flash('خطا!', 'error', [
            'text' => 'شماره موبایل یا رمز عبور اشتباه است.',
            'type' => 'error',
            'showConfirmButton' => true,
        ]);
        return redirect()->back();
    }

    /**
     * Get the login username to be used by the controller.
     *
     * @return string
     */
    public function username()
    {
        return 'mobile';
    }

    /**
     * Get the post register / login redirect path.
     *
     * @param $user
     * @return string
     */
    public function redirectPath()
    {
        if (method_exists($this, 'redirectTo')) {
            return $this->redirectTo();
        }

        return property_exists($this, 'redirectTo') ? $this->redirectTo : '/';
    }

    /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request $request
     * @param Factory $cookie
     * @return \Illuminate\Http\Response
     */
    public function logout(Request $request,Factory $cookie)
    {
//        Cart::addToCartInLogout($cookie);

        $this->guard()->logout();

        $request->session()->invalidate();

        alert()->flash('خارج شدید', 'success', [
            'text' => 'باز هم تشریف بیاورید',
            'type' => 'success',
            'showConfirmButton' => false,
            'timer' => 2200
        ]);

        return redirect('/');
    }
}
