<?php

namespace App\Http\Controllers\Auth;

use App\Events\ResetPassEvent;
use App\Http\Controllers\Controller;
use App\Models\PasswordReset;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\URL;

class ForgotPasswordController extends Controller
{

    /**
     * Create a new controller instance.
     *
     */
    public function __construct()
    {
        $this->middleware('guest');
    }
//1-get
    protected function showLinkRequestForm(){

        return view('public.SiteFront.auth.forgotPasswordReq');
    }
//1-post
    protected function sendSms(Request $request){

        $this->validate($request, [
            'mobile' => ['required','digits:11','regex:/^(0)?(9[0-9]{9})$/'],
        ]);

        $request = $request->all();

        $user = User::where('mobile',$request['mobile'])->first();

        if(isset($user)){

            Event::fire(new ResetPassEvent($user));

            $token = encrypt_decrypt('encrypt',$request['mobile']);
            $user->update([
                'token' => $token,
            ]);

            return redirect($this->redirectTo($user));

        }else{
            alert()->flash('شماره موبایل صیح نیست', 'error', [
                'text' => "چنین کاربری قبلا ثبت نشده",
                'showConfirmButton' => true,
            ]);
            return redirect()->back();
        }
    }

//2-get
    protected function codeForm(Request $request,$token){

        $request = $request->all();

        if(isset($token)){
            $user = User::where('token',$token)->first();

            if((URL::previous() == url('/password/forgot') || URL::previous() == url('/password/reset/code/'.$token)) && !is_null($token) )
            {
                if(isset($user)){
                    if($user->token == $token){

                        return  view('public.SiteFront.auth.forgotPasswordCode',compact('token'));
                    }
                }else{
                    return redirect()->back();
                }
            }
        }

        return redirect(route('home'));

    }

//2-post
    protected function codeCheck(Request $request)
    {

        $this->validate($request, [
            'passwordCode' => ['required', 'digits:5'],
        ]);

        $request = $request->all();

        $code = PasswordReset::where('sms_code', $request['passwordCode'])->first();

        if (isset($code)) {
            if (isset($request['refurl'])) {

                $user = User::where('token', $request['refurl'])->first();

                if (isset($user)) {
                    if ($user->token == $request['refurl']) {
                        return redirect('password/reset/forgot/' . $request['refurl']);
                    }
                }
            } else {
                alert()->flash('خطا', 'error', [
                    'text' => "کد وارد شده صحیح نمی باشد",
                    'showConfirmButton' => false,
                    'timer' => 1500
                ]);
            }

        }
        return redirect()->back();
    }

//3-get
    protected function showResetForm(Request $request,$token){

        if(isset($token)){
            $user = User::where('token',$token)->first();
            if((URL::previous() == url('password/reset/code/'.$token)) && !is_null($token) )
            {
                if(isset($user)){
                    if($user->token == $token){
                        return  view('public.SiteFront.auth.forgotPassReset',compact('token'));
                    }
                }else{
                    return redirect()->back();
                }
            }
        }

        return redirect(route('home'));
    }

//3-post
    protected function reset(Request $request){

        $this->validate($request, [
            'password'=>'confirmed|required|max:60|min:6'
        ]);
        $request = $request->all();

        $user = User::where('token',$request['token'])->firstOrFail();

        $user->update([
            'password' => bcrypt($request['password']),
            'token'    => null
        ]);

        $pass_reset = PasswordReset::where('user_id',$user->id)->first();

        deleteSimple($pass_reset);

        alert()->flash('بروزرسانی شد', 'success', [
            'text' => "رمز عبور شما با موفقیت بروزرسانی شد، لطفا با رمز جدید وارد شوید",
            'showConfirmButton' => true,
        ]);

        return redirect(route('login.show'));
    }


    protected function redirectTo($user){

        $token = encrypt_decrypt('encrypt',$user->mobile);

        return 'password/reset/code/'.$token;
    }

}
