<?php

namespace App\Http\Controllers\Anbar;

use App\Models\Category;
use App\Models\ProductsTecInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Morilog\Jalali\jDate;
class TecInfoNestableController extends Controller
{


    protected function index(Category $category){


        $activeTecInfos = $category->TecInfo()
            ->where('status',1)
            ->where('parent_id',0)
            ->orderBy('hierarchy', 'asc')
            ->get();
        $deActiveTecInfos = $category->TecInfo()
            ->where('status',0)
            ->where('parent_id',0)
            ->orderBy('hierarchy', 'asc')
            ->get();

        $jdate = new jDate();

        return(view('/CRM/Anbar/tecInfoNestable/all',compact( 'jdate','category','activeTecInfos','deActiveTecInfos' )));

    }

    protected function store(Request $request){

        $request = $request->all();

        $actives = json_decode($request['tecInfoOrder'],True);
        $parent_id = 0;
        for ($i=0; $i < count($actives); $i++) {
            $this->apply_hierarchy($actives[$i], $i+1, $parent_id);
        }

        $deActives = json_decode($request['tecInfoOrder2'],True);

        for ($i=0; $i < count($deActives); $i++) {
            $this->apply_hierarchy($deActives[$i], $i+1, $parent_id,0);
        }

        alert()->flash('ثبت شد', 'success', [
            'text' => "تغییرات با موفقیت ثبت شد",
            'timer' => 1200
        ]);

        return redirect()->back();
    }

    public function apply_hierarchy($menuItem, $num, $parent_id,$status = 1)
    {
        $menu = ProductsTecInfo::find($menuItem['id']);
        $menu->parent_id = $parent_id;
        $menu->hierarchy = $num;
        $menu->status = $status;
        $menu->save();

        if(isset($menuItem['children'])) {
            for ($i=0; $i < count($menuItem['children']); $i++) {
                $this->apply_hierarchy($menuItem['children'][$i], $i+1, $menuItem['id'],$status);
            }
        }
    }
}
