<?php

namespace App\Http\Controllers\Anbar;

use App\Models\Category;
use App\Models\ProductsTecInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Morilog\Jalali\jDate;

class TecInfoController extends Controller
{

    protected function index(Category $category){


        $tecInfos = $category->TecInfo()->get();
        $jdate = new jDate();

        return(view('/CRM/Anbar/tecInfo/all',compact( 'jdate','category','tecInfos' )));

    }

    protected function addShow(Category $category){

        return view('CRM.Anbar.tecInfo.create',compact('category'));

    }

    protected function store(Category $category,Request $request){
        $request = $request->all();

        unset($request['_token']);

        $errors = [];
        foreach ($request as $req){
            $validator = Validator::make(
                ['tec_info_key'=> $req['tec']],
                [
                    'tec_info_key' => 'required|string',
                ]
            );

            if($validator->fails()){
                $errors = $validator->errors();
            }
        }

        if(!empty($errors)){
            return redirect()->back()->with(['errors' => $errors ,'stuffs' => $request]);
        }else{

            foreach ($request as $req){
                if(!is_null($req['tec'])){

                    $tec = ProductsTecInfo::orderBy('code','desc')->first();
                    if(isset($tec)){
                        if(!is_null($tec->code)){
                             $tec->code++;
                             $code = $tec->code;
                        } else{
                            $code = 'AA111';
                        }
                    }else{
                        $code = 'AA111';
                    }

                    ProductsTecInfo::create([
                        'tec_info_key'  => $req['tec'],
                        'category_id'   => $category->id,
                        'code'          => $code
                    ]);
                }
            }
        }

        alert()->flash('ثبت شد', 'success', [
            'text' => "مشخصات فنی با موفقیت ثبت شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);


        return redirect(route('tecInfo.show',$category));
    }

    protected function edit(ProductsTecInfo $tecInfo){

        $categories = Category::latest()->get();
        return view('CRM.Anbar.tecInfo.edit',compact('categories','tecInfo'));

    }

    protected function update(ProductsTecInfo $tecInfo,Request $request){

        $this->validate($request,[
            'tec_info_key' => 'required|string',
            'category_id' => 'required|integer|exists:category,id'

        ]);

        $request = $request->all();

        $category = $tecInfo->Category()->first();

        $tecInfo->update([
            'tec_info_key' => $request['tec_info_key'],
            'category_id'  => $request['category_id']
        ]);

        alert()->flash('ویرایش شد', 'success', [
            'text' => "مشخصات فنی با موفقیت ویرایش شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);


        return redirect(route('tecInfo.show',$category));
    }

    protected function delete(Category $category,ProductsTecInfo $tecInfo){

        deleteRecord($tecInfo);

        return redirect(route('tecInfo.show',$category));

    }

}
