<?php
namespace App\Http\Controllers\Anbar;

use App\Http\Controllers\Controller;
use App\Http\Requests\StuffTypeRequest;
use App\Models\StuffType;
use Illuminate\Http\Request;

class StuffTypeController extends Controller
{
    protected function index(){
        $items = $this->showItems();

        return(view('/CRM/Anbar/StuffType/createStuffType',compact( 'items' ) ));
    }

    protected function editStuffType($stuffTypeId){

        $stuffType = new StuffType();
        $stuffTypeInfo = $stuffType->whereraw("id = $stuffTypeId")->first();

        if( !empty( $stuffTypeInfo )){

            $stuffTypeName = $stuffTypeInfo['stuffType'];

            return view('/CRM/Anbar/StuffType/editStuffTypeDetail',compact( 'stuffTypeId' ,'stuffTypeName') );

        } else {
            $message = "امکان ویرایش نوع کالا مورد نظر وجود ندارد.";
            $messageType = "failure";
            session()->flash('message',$message);
            session()->flash('messageType',$messageType);

            return(redirect('/CRM/Anbar/StuffType/createStuffType'));
        }

    }


    protected function addNewItem(Request $request){
        $request = $request->all();
        unset($request['_token']);
        foreach ($request as $key=>$value){
            if( !is_null( $value ) && is_numeric( $key )){
                $stuffType = new StuffType();
                $stuffType->updateOrCreate(
                    ['stuffType' =>  $value ]
                );
            }
        }
        $message = "نوع کالا ها با موفقیت تعریف شد";
        $messageType = "success";
        session()->flash('message',$message);
        session()->flash('messageType',$messageType);

        return(redirect('/CRM/createStuffType') );
    }

    protected function saveEditStuffType(StuffTypeRequest $request){

        $request = $request->all();
        unset($request['_token']);
        $stuffTypeId = $request['stuffTypeId'];
        $stuffTypeName = $request['stuffTypeName'];
        if( !is_null( $stuffTypeName )){
            $stuffType = new StuffType();
            $stuffType->whereraw("id = '$stuffTypeId'")->update(["stuffType" => $stuffTypeName]);
            $message = "نوع کالا با موفقیت ویرایش گردید";
            $messageType = "success";
            session()->flash('message',$message);
            session()->flash('messageType',$messageType);
            return(redirect('CRM/createStuffType'));
        }else{
            $message = 'فیلد در هنگام ویرایش نمی تواند خالی باشد ';
            $messageType = "failure";
            session()->flash('message',$message);
            session()->flash('messageType',$messageType);
            return(redirect(route('Role_Show')));
        }

    }

    protected function deleteStuffType($stuffTypeId){

        $stuffType = new StuffType();
        $stuffTypeInfo = $stuffType->whereraw("id =$stuffTypeId")->first();


        if( !empty( $stuffTypeInfo )){
            deleteRecord($stuffTypeInfo);
            return(redirect('CRM/createStuffType'));
        } else {
            $message = "امکان حذف نوع کالا مورد نظر وجود ندارد.";
            $messageType = "failure";
            session()->flash('message',$message);
            session()->flash('messageType',$messageType);

            return(redirect('CRM/createStuffType'));
        }


    }

    protected function showItems(){
        $stuffType = new StuffType();
        $stuffType = $stuffType->all();
        return($stuffType);
    }
}
