<?php

namespace App\Http\Controllers\Anbar;

use App\Models\Category;
use App\Models\Size;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali\jDate;

class SizeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param Category $category
     * @return \Illuminate\Http\Response
     */
    public function index(Category $category)
    {
        $sizes = $category->Size()->get();
        $jdate = new jDate();

        return view('CRM.Anbar.size.all',compact( 'jdate','category','sizes' ));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param Category $category
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Category $category,Request $request)
    {
        $this->validate($request,[
            'name' => 'required|string|max:250'
        ]);

        $size = Size::orderBy('code','desc')->first();
        if(isset($size)){
            if(!is_null($size->code)){
                $size->code++;
                $code = $size->code;
            } else{
                $code = 'SAA111';
            }
        }else{
            $code = 'SAA111';
        }

        Size::create([
            'name'  => $request['name'],
            'category_id'   => $category->id,
            'code'          => $code
        ]);

        alert()->flash('ثبت شد', 'success', [
            'text' => "سایز با موفقیت ثبت شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);

        return redirect(route('size.show',$category));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param Size $size
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function edit(Size $size)
    {
        $categories = Category::latest()->get();
        return view('CRM.Anbar.size.edit',compact( 'categories','size' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param Size $size
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function update(Request $request, Size $size)
    {
        $this->validate($request,[
            'name' => 'required|string|max:250',
            'category_id' => 'required|integer|min:1|exists:category,id'
        ]);
        $category = $size->Category()->first();

        $size->update($request->all());

        alert()->flash('ویرایش شد', 'success', [
            'text' => "سایز با موفقیت ویرایش شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);

        return redirect(route('size.show',$category));

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Size $size
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function destroy(Size $size)
    {
        $category = $size->Category()->first();

        deleteRecord($size);

        return redirect(route('size.show',$category));
    }
}
