<?php

namespace App\Http\Controllers\Anbar;

use App\Helpers\LAHelper;
use App\Http\Controllers\Controller;
use App\Models\Products;
use App\Models\ProductsTecInfo;
use App\Models\TecInfoProduct;
use Illuminate\Http\Request;

class ProductTecInfoController extends Controller
{

    protected function tecInfoIndex(Products $product){
        $category = $product->Category()->first();

        $tecs = ProductsTecInfo::getTecs($category);

        return view('CRM.Anbar.Product.tecInfo',compact('product','tecs'));

    }

    protected function tecInfoStore(Request $request,Products $product){
        if(!$request->has('tecInfo_id') || !$request->has('value')){
            alert()->flash('خطا', 'error', [
                'text' => "مشخصات فنی مقدار ندارد یا اینکه در مشخصات فنی فقط از عنوان استفاده شده",
                'type' => 'error',
            ]);
            return redirect()->back();
        }
        $rules = [];
        foreach($request->get('tecInfo_id') as $key => $val) {
            $rules['tecInfo_id.'.$key] = ['required','numeric','min:1'];
        }
        foreach($request->get('value') as $key => $val) {
            $rules['value.'.$key] = ['required','string'];
        }
        $this->validate($request,$rules);

        $request = $request->all();

        for($i = 0; $i < count($request['tecInfo_id']); $i++){

            TecInfoProduct::updateOrCreate(
                [
                    'tecInfo_id' => $request['tecInfo_id'][$i],
                    'product_id' => $product->id
                ],
            [
                'value' => $request['value'][$i]
            ]
            );
        }


        alert()->flash('ثبت شد', 'success', [
            'text' => "مشخصات فنی با موفقیت ثبت شد",
            'type' => 'success',
            'timer' => 1100,
        ]);

        return redirect(route('product.show',$product));
    }



}
