<?php

namespace App\Http\Controllers\Anbar;

use App\Helpers\LAHelper;
use App\Http\Controllers\Controller;
use App\Models\ProductPdf;
use App\Models\Products;
use App\Models\ProductsTecInfo;
use App\Models\TecInfoProduct;
use Illuminate\Http\Request;

class ProductPdfController extends Controller
{

    public function store(Request $request,Products $product){
        $request->validate([
            'title'=>'required',
            'pdf'=>'required|mimes:pdf'
        ]);
        $file = $request->file('pdf');
        $path = $this->uploadFile($file);

        $product->pdfs()->create([
            'title'=>$request->title,
            'pdf'=>$path
        ]);

        return back();
    }

    public function destroy(ProductPdf $pdf){

        try{unlink(public_path($pdf->pdf));}catch (\Exception $e){};
        $pdf->delete();
        return back();
    }

    protected function uploadFile($file)

    {
        $fileName1 = time() . rand(100, 999).'.'.$file->getClientOriginalExtension();

        $resize_dirPath = public_path('/app/pdf/');

        $file->move($resize_dirPath,$fileName1);
        $public_path = '/app/pdf/' . $fileName1;
        return $public_path;
    }

}
