<?php

namespace App\Http\Controllers\Anbar;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProductRequest;
use App\Models\Brands;
use App\Models\Category;
use App\Models\Products;
use App\Models\ProductsColor;
use App\Models\StuffType;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $products = Products::latest()->with(['StuffType','Category','Brand'])->get();


        $active_class['child'] = 'product.list';

        return view('CRM.Anbar.Product.all',compact('products','active_class'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::get();
        $brands = Brands::get();

        $active_class['child'] = 'product.create';

        return view('CRM.Anbar.Product.create',compact('categories','brands','active_class'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProductRequest $request)
    {

        $brand = Brands::whereId($request['brand_id'])->first();

        $category = Category::whereId($request['category_id'])->first();

        $stuffType = $category->StuffType()->first();

        if(!empty($request['discount_sell_price'])){
            if($request['discount_sell_price'] > $request['base_sell_price']){
                alert()->flash('خطا', 'error', [
                    'text' => "قیمت فروش با تخفیف نمی تواند از قیمت پایه بیشتر باشد",
                    'showConfirmButton' => true,
                ]);
                return redirect()->back();
            }
        }

        $product = Products::create([
            'name'                  => $request['name'],
            'eng_name'              => $request['eng_name'],
            'brand'                 => $brand->brandName,
            'category'              => $category->category,
            'stuffType'             => $stuffType->stuffType,
            'brand_id'              => $request['brand_id'],
            'category_id'           => $request['category_id'],
            'stuffType_id'          => $stuffType->id,
            'base_sell_price'       => $request['base_sell_price'],
            'discount_sell_price'   => $request['discount_sell_price'],
            'alarm_level'           => $request['alarm_level'],
            'short_description'     => $request['description'],
            'review'                => $request['review'],
            'weight'                => $request['weight'],
            'type'                  => $category->type,
            'qty'                   => $request['qty'],
            'buy'                   => $request['buy'],
        ]);

        $product->update(['code' => $product->getProductId()]);

//        product color default
        $pc =  ProductsColor::create([
            'type'                  =>  $product->type,
            'product_id'            =>  $product->id,
            'base_sell_price'       =>  $request['base_sell_price'],
            'discount_sell_price'   =>  $request['discount_sell_price'],
            'discount'              =>  $request['base_sell_price'] - $request['discount_sell_price'],
            'priority'              =>  1,
            'status'                =>  1,
            'code'                  =>  0,
            'available'             =>  1,
            'qty'                   => $request['qty'],
        ]);

        $pc->update(['code' => $pc->getColorProductId()]);


        alert()->flash('ثبت شد', 'success', [
            'text' => "مشخصات کالا با موفقیت ثبت شد",
            'type' => 'success',
            'timer' => 1100,
        ]);
        return redirect(route('product.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param Products $product
     * @return \Illuminate\Http\Response
     * @internal param Products $products
     */
    public function show(Products $product)
    {


        $productsColorLimit = $product->qty - $product->productsColor()->get()->sum('qty');

        return view('CRM.Anbar.Product.show',compact('active_class','productsColorLimit','product'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Products $product
     * @return \Illuminate\Http\Response
     * @internal param Products $products
     */
    public function edit(Products $product)
    {
        $categories = Category::get();
        $brands = Brands::get();



        return view('CRM.Anbar.Product.edit',compact('active_class','categories','brands','product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param Products $product
     * @return \Illuminate\Http\Response
     * @internal param Products $products
     */
    public function update(Request $request, Products $product)
    {

        $rules = array();
        $rules['name']                  = ['required','string','unique:products,'.$product->id];
        $rules['eng_name']              = ['required','string','unique:products,'.$product->id];
        $rules['brand_id']              = ['required','numeric','min:1','exists:brands,id'];
        $rules['category_id']           = ['required','numeric','min:1','exists:category,id'];
        $rules['base_sell_price']       = ['required','numeric','min:1000'];
        $rules['discount_sell_price']   = ['nullable','numeric','min:1000'];
        $rules['alarm_level']           = ['required','numeric','min:1'];
        $rules['weight']                = ['required','numeric','min:1'];
        $rules['qty']                   = ['required','numeric','min:1'];
        $rules['buy']                   = ['required','numeric','min:100'];



        $brand = Brands::whereId($request['brand_id'])->first();

        $category = Category::whereId($request['category_id'])->first();
        $stuffType = $category->StuffType()->first();

        if(!empty($request['discount_sell_price'])){
            if($request['discount_sell_price'] > $request['base_sell_price']){
                alert()->flash('خطا', 'error', [
                    'text' => "قیمت فروش با تخفیف نمی تواند از قیمت پایه بیشتر باشد",
                    'showConfirmButton' => true,
                ]);
                return redirect()->back();
            }
        }

        $product->update([
            'name'                  => $request['name'],
            'eng_name'              => $request['eng_name'],
            'brand'                 => $brand->brandName,
            'category'              => $category->category,
            'stuffType'             => $stuffType->stuffType,
            'brand_id'              => $request['brand_id'],
            'category_id'           => $request['category_id'],
            'stuffType_id'          => $stuffType->id,
            'base_sell_price'       => $request['base_sell_price'],
            'discount_sell_price'   => $request['discount_sell_price'],
            'alarm_level'           => $request['alarm_level'],
            'short_description'     => $request['description'],
            'review'                => $request['review'],
            'weight'                => $request['weight'],
            'type'                  => $category->type,
            'qty'                   => $request['qty'],
            'buy'                   => $request['buy'],
        ]);

        $productColor = $product->productsColor()->first();

        $productColor->update([
            'base_sell_price'       =>  $request['base_sell_price'],
            'discount_sell_price'   =>  $request['discount_sell_price'],
            'discount'              =>  $request['base_sell_price'] - $request['discount_sell_price'],
            'qty'                   =>  $request['qty'],
        ]);

        alert()->flash('ویرایش شد', 'success', [
            'text' => "مشخصات کالا با موفقیت ویرایش شد",
            'type' => 'success',
            'timer' => 1100,
        ]);
        return redirect(route('product.show',$product));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Products $product
     * @return \Illuminate\Http\Response
     * @internal param Products $products
     */
    public function destroy(Products $product)
    {
        //
    }

    protected function brandIndex(Brands $brand){

        $products = $brand->products()->get();

        return view('CRM.Anbar.Product.sort.byBrand',compact( 'products','brand' ));
    }

    protected function categoryIndex(Category $category){

        $products = $category->Products()->get();

        return view('CRM.Anbar.Product.sort.byCategory',compact( 'products','category' ));

    }

    protected function stuffTypeIndex(StuffType $stuffType){

        $products = $stuffType->Product()->get();

        return view('CRM.Anbar.Product.sort.byStuffType',compact( 'products','stuffType' ));
    }

    protected function availableIndex($type,$available,$id = 'all'){
        $active_class['parent'] = 'inventory';
        $active_class['child'] = 'product.list';

        if($type == 'brand')
        {
            $brand = Brands::whereId($id)->first();

            $products = $brand->products()->where('available',$available)->get();

            $name = $brand->brandName;

            return view('CRM.Anbar.Product.all',compact('name','products','available','active_class'));
        }
        elseif($type == 'category')
        {
            $category = Category::whereId($id)->first();

            $products = $category->Products()->where('available',$available)->get();

            $name = $category->category;

            return view('CRM.Anbar.Product.all',compact('name','products','available','active_class'));
        }
        elseif($type == 'stuffType')
        {
            $stuffType = StuffType::whereId($id)->first();

            $products = $stuffType->Product()->where('available',$available)->get();

            $name = $stuffType->stuffType;

            return view('CRM.Anbar.Product.all',compact('name','products','available','active_class'));
        }

        $products = Products::where('available',$available)->get();

        return view('CRM.Anbar.Product.all',compact('products','available','active_class'));
    }

    protected function statusIndex($type,$status,$id = 'all'){
        $active_class['parent'] = 'inventory';
        $active_class['child'] = 'product.list';

        if($type == 'brand')
        {
            $brand = Brands::whereId($id)->first();

            $products = $brand->products()->where('status',$status)->get();

            $name = $brand->brandName;

            return view('CRM.Anbar.Product.all',compact('name','products','status','active_class'));
        }
        elseif($type == 'category')
        {
            $category = Category::whereId($id)->first();

            $products = $category->Products()->where('status',$status)->get();

            $name = $category->category;

            return view('CRM.Anbar.Product.all',compact('name','products','status','active_class'));
        }
        elseif($type == 'stuffType')
        {
            $stuffType = StuffType::whereId($id)->first();

            $products = $stuffType->Product()->where('status',$status)->get();

            $name = $stuffType->stuffType;

            return view('CRM.Anbar.Product.all',compact('name','products','status','active_class'));
        }

        $products = Products::where('status',$status)->get();

        return view('CRM.Anbar.Product.all',compact('products','status','active_class'));
    }

    protected function qtyIndex($type,$qty,$id){
        $active_class['parent'] = 'inventory';
        $active_class['child'] = 'product.list';

        if($type == 'brand')
        {
            $brand = Brands::whereId($id)->first();
            if($qty == 'not-available')
                $products = $brand->products()->where('qty',0)->get();
            else
                $products = $brand->products()->where('qty','!=',0)->get();

            $name = $brand->brandName;

            return view('CRM.Anbar.Product.all',compact('name','products','qty','active_class'));
        }
        elseif($type == 'category')
        {
            $category = Category::whereId($id)->first();
            if($qty == 'not-available')
                $products = $category->Products()->where('qty',0)->get();
            else
                $products = $category->Products()->where('qty','!=',0)->get();


            $name = $category->category;

            return view('CRM.Anbar.Product.all',compact('name','products','qty','active_class'));
        }
        elseif($type == 'stuffType')
        {
            $stuffType = StuffType::whereId($id)->first();
            if($qty == 'not-available')
                $products = $stuffType->Product()->where('qty',0)->get();
            else
                $products = $stuffType->Product()->where('qty','!=',0)->get();

            $name = $stuffType->stuffType;

            return view('CRM.Anbar.Product.all',compact('name','products','qty','active_class'));
        }
        if($qty == 'not-available')
            $products = Products::where('qty',0)->get();
        else
            $products = Products::where('qty','!=',0)->get();

        return view('CRM.Anbar.Product.all',compact('products','qty','active_class'));
    }

    protected function getModal(Request $request){


        if($request->ajax()){

            $this->validate($request,[
                'id' => 'required|numeric|exists:products,id|min:1'
            ]);
            $request = $request->all();
            $product = Products::whereId($request['id'])->first();

            return view('CRM.Anbar.Product.modal',compact('product'));
        }

        return redirect()->back();
    }

    protected function changeStatus(Request $request, Products $products){

        $this->validate($request,[
           'status' => 'required|numeric|min:0|max:1' ,
           'available' => 'required|numeric|min:0|max:1'
        ]);

        $products->update($request->all());

       $status = $request->status == 0 ? 'غیر فعال':'فعال';
       $available = $request->available == 0 ? 'ناموجود':'موجود';

        alert()->flash('ثبت شد', 'success', [
            'text' => "وضعیت کالا با موفقیت به " . $status ." و " . $available . " تغییر یافت ",
            'type' => 'success',
        ]);

        return redirect()->back();
    }
}
