<?php

namespace App\Http\Controllers\Anbar;

use App\Models\ColorStore;
use App\Models\Products;
use App\Models\ProductsColor;
use App\Models\Size;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali\jDate;

class ProductColorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param Products $product
     * @return \Illuminate\Http\Response
     */
    public function index(Products $product)
    {
        $productColors = $product->productsColor()->get();

        return view('CRM.Anbar.productColor.all',compact('product','productColors'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Products $product
     * @return \Illuminate\Http\Response
     */
    public function create(Products $product)
    {
        $productColors = $product->productsColor()->get();

        $amount = $productColors->sum('amount');

        $limit = $product->Inventory()->first()->stuff_number - $amount;

        if($product->type == 0 || $product->type == 2){
            $colors = ColorStore::latest()->get();
        }
        if($product->type == 1 || $product->type == 2){
            $sizes = Size::where('category_id',$product->Category()->first()->id)->latest()->get();
        }

        $latest = $product->productsColor()->orderBy('priority','desc')->first();

        return view('CRM.Anbar.productColor.create',compact('latest','sizes','product','limit','colors'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param Products $product
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request,Products $product)
    {

        $rules = array();
        if($product->type == 0 || $product->type == 2){
            $rules['color_id'] = ['required','integer','exists:color_store,id','min:1'];
        }
        if($product->type == 1 || $product->type == 2){
            $rules['size_id'] = ['required','integer','exists:sizes,id','min:1'];
        }
        $rules['amount'] = ['required','integer','min:1'];
        $rules['base_sell_price'] = ['required','numeric','min:1000'];
        $rules['discount_sell_price'] = ['nullable','numeric','min:1000'];
        $rules['priority'] = ['required','integer','min:1'];
        $rules['status'] = ['required','integer','min:0','max:1'];


        $this->validate($request,$rules);

        if($request['amount'] > $request['color_limit']){

            alert()->flash('خطا', 'warning', [
                'text' => "شما مجاز به تعیین رنگ، بیشتر از موجودی انبار نمی باشید",
                'showConfirmButton' => true,
            ]);
            return redirect()->back();
        }
        if($request['discount_sell_price'] > $request['base_sell_price']){
            alert()->flash('خطا', 'error', [
                'text' => "قیمت فروش با تخفیف نمی تواند از قیمت پایه بیشتر باشد",
                'showConfirmButton' => true,
            ]);
            return redirect()->back();
        }


        if(!is_null($request['discount_sell_price'])){
            $discount = $request['base_sell_price'] - $request['discount_sell_price'];
        }else{
            $discount = null;
        }
        if($product->type == 0){
            $productColor = ProductsColor::where('product_id', $product->id)->where('color_id',$request['color_id'])->withTrashed()->first();
            $type = 'رنگ';
            if(!isset($productColor)){
                $pc =  ProductsColor::create([
                    'type'                  =>  $product->type,
                    'product_id'            =>  $product->id,
                    'color_id'              =>  $request['color_id'],
                    'amount'                =>  $request['amount'],
                    'base_sell_price'       =>  $request['base_sell_price'],
                    'discount_sell_price'   =>  $request['discount_sell_price'],
                    'discount'              =>  $discount,
                    'priority'              =>  $request['priority'],
                    'status'                =>  $request['status'],
                    'code'                  =>  0
                ]);

                $pc->update(['code' => $pc->getColorProductId()]);
            }
        }elseif($product->type == 1){
            $productColor = ProductsColor::where('product_id', $product->id)->where('size_id',$request['size_id'])->withTrashed()->first();
            $type = 'سایز';
            if(!isset($productColor)) {
                $pc =   ProductsColor::create([
                    'type' => $product->type,
                    'product_id' => $product->id,
                    'size_id' => $request['size_id'],
                    'amount' => $request['amount'],
                    'base_sell_price' => $request['base_sell_price'],
                    'discount_sell_price' => $request['discount_sell_price'],
                    'discount' => $discount,
                    'priority' => $request['priority'],
                    'status' => $request['status'],
                    'code'                =>  0
                ]);
                $pc->update(['code' => $pc->getColorProductId()]);

            }
        }elseif($product->type == 2){
            $productColor = ProductsColor::where('product_id', $product->id)->where('size_id',$request['size_id'])
                ->where('color_id',$request['color_id'])->withTrashed()->first();
            $type = 'سایز و رنگ';
            if(!isset($productColor)) {
                $pc =  ProductsColor::create([
                    'type' => $product->type,
                    'product_id' => $product->id,
                    'color_id' => $request['color_id'],
                    'size_id' => $request['size_id'],
                    'amount' => $request['amount'],
                    'base_sell_price' => $request['base_sell_price'],
                    'discount_sell_price' => $request['discount_sell_price'],
                    'discount' => $discount,
                    'priority' => $request['priority'],
                    'status' => $request['status'],
                    'code'                =>  0
                ]);
                $pc->update(['code' => $pc->getColorProductId()]);

            }
        }
        if(isset($productColor)){
            if(is_null($productColor->deleted_at)){
                $amount = $productColor->amount + $request['amount'];
                $productColor->update([
                    'amount' => $amount
                ]);
            }else{
                $productColor->restore();
                $productColor->update([
                    'amount' => $request['amount']
                ]);
            }

        }


        $this->lessPriceUpdate($product);


        alert()->flash('ثبت شد', 'success', [
            'text' => $request['amount']." عدد از کالا تعیین ". $type ." شد ",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ProductsColor  $productsColor
     * @return \Illuminate\Http\Response
     */
    public function show(ProductsColor $productsColor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProductsColor  $productsColor
     * @return \Illuminate\Http\Response
     */
    public function edit(ProductsColor $productsColor)
    {
        $product = $productsColor->Product()->first();

        $productColors = $product->productsColor()->get();

        $amount = $productColors->sum('amount');

        $limit = $product->Inventory()->first()->stuff_number - $amount + $productsColor->amount;

        if($product->type == 0 || $product->type == 2){
            $colors = ColorStore::latest()->get();
        }
        if($product->type == 1 || $product->type == 2){
            $sizes = Size::where('category_id',$product->Category()->first()->id)->latest()->get();
        }

        $latest = $product->productsColor()->orderBy('priority','desc')->first();

        return view('CRM.Anbar.productColor.edit',compact('latest','productsColor','sizes','product','limit','colors'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ProductsColor  $productsColor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProductsColor $productsColor)
    {
        $category = $productsColor->Product()->first()->Category()->first();

        $rules = array();
        if($category->type == 0 || $category->type == 2){
            $rules['color_id'] = ['required','integer','exists:color_store,id','min:1'];
        }
        if($category->type == 1 || $category->type == 2){
            $rules['size_id'] = ['required','integer','exists:sizes,id','min:1'];
        }
        $rules['amount'] = ['required','integer','min:1'];
        $rules['base_sell_price'] = ['required','integer','min:1000'];
        $rules['discount_sell_price'] = ['nullable','numeric','min:1000'];
        $rules['priority'] = ['required','numeric','min:1'];
        $rules['status'] = ['required','integer','min:0','max:1'];


        $this->validate($request,$rules);

        $product = $productsColor->Product()->first();

        if($request['amount'] > $request['color_limit']){

            alert()->flash('خطا', 'warning', [
                'text' => "شما مجاز به تعیین رنگ، بیشتر از موجودی انبار نمی باشید",
                'showConfirmButton' => true,
            ]);
            return redirect()->back();
        }
        if($request['discount_sell_price'] > $request['base_sell_price']){
            alert()->flash('خطا', 'error', [
                'text' => "قیمت فروش با تخفیف نمی تواند از قیمت پایه بیشتر باشد",
                'showConfirmButton' => true,
            ]);
            return redirect()->back();
        }

        if(!is_null($request['discount_sell_price'])){
            $discount = $request['base_sell_price'] - $request['discount_sell_price'];
        }else{
            $discount = null;
        }
        if($category->type == 0){
            if($productsColor->color_id != $request['color_id']){
                $before = ProductsColor::where('product_id',$product->id)->where('color_id',$request['color_id'])->first();
                if(isset($before)){
                    $before->update([
                        'amount' => $before->amount + $request['amount'],
                        'base_sell_price' => $request['base_sell_price'],
                        'discount_sell_price' => $request['discount_sell_price'],
                        'discount' => $discount,
                        'priority' => $request['priority'],
                        'status' => $request['status']
                    ]);
                }else{
                    if($productsColor->type != $product->type || $product->type != $category->type || $productsColor->type != $category->type){

                        $this->checkTypes($category,$product,$productsColor,$request,$discount);

                    }else {
                        alert()->flash('ویرایش نشد', 'warning', [
                            'text' => 'چنین کالایی قبلا ثبت نشده، در صورت نیاز، ابتدا آن را ثبت کنید',
                            'showConfirmButton' => true,
                        ]);

                        return back();
                    }
                }
                if($productsColor->amount <= $request['amount']){
                    deleteSimple($productsColor);
                }else{
                    $productsColor->update([
                        'amount' => $productsColor->amount - $request['amount'],
                    ]);
                }
            }else{
                $productsColor->update([
                    'amount' => $request['amount'],
                    'base_sell_price' => $request['base_sell_price'],
                    'discount_sell_price' => $request['discount_sell_price'],
                    'discount' => $discount,
                    'priority' => $request['priority'],
                    'status' => $request['status']
                ]);
            }
        }elseif($category->type == 1){
            if($productsColor->size_id != $request['size_id']){
                $before = ProductsColor::where('product_id',$product->id)->where('size_id',$request['size_id'])->first();
                if(isset($before)){
                    $before->update([
                        'amount' => $before->amount + $request['amount'],
                        'base_sell_price' => $request['base_sell_price'],
                        'discount_sell_price' => $request['discount_sell_price'],
                        'discount' => $discount,
                        'priority' => $request['priority'],
                        'status' => $request['status']
                    ]);
                }else{
                    if($productsColor->type != $product->type || $product->type != $category->type || $productsColor->type != $category->type){

                        $this->checkTypes($category,$product,$productsColor,$request,$discount);

                    }else {
                        alert()->flash('ویرایش نشد', 'warning', [
                            'text' => 'چنین کالایی قبلا ثبت نشده، در صورت نیاز، ابتدا آن را ثبت کنید',
                            'showConfirmButton' => true,
                        ]);

                        return back();
                    }
                }
                if($productsColor->amount <= $request['amount']){
                    deleteSimple($productsColor);
                }else{
                    $productsColor->update([
                        'amount' => $productsColor->amount - $request['amount'],
                    ]);
                }
            }else{
                $productsColor->update([
                    'amount' => $request['amount'],
                    'base_sell_price' => $request['base_sell_price'],
                    'discount_sell_price' => $request['discount_sell_price'],
                    'discount' => $discount,
                    'priority' => $request['priority'],
                    'status' => $request['status']
                ]);
            }

        }elseif($category->type == 2){
            if($productsColor->size_id != $request['size_id'] && $productsColor->color_id != $request['color_id']){
                $before = ProductsColor::where('product_id',$product->id)
                    ->where('size_id',$request['size_id'])
                    ->where('color_id',$request['color_id'])
                    ->first();
                if(isset($before)){
                    $before->update([
                        'amount' => $before->amount + $request['amount'],
                        'base_sell_price' => $request['base_sell_price'],
                        'discount_sell_price' => $request['discount_sell_price'],
                        'discount' => $discount,
                        'priority' => $request['priority'],
                        'status' => $request['status']
                    ]);
                }else{
                    if($productsColor->type != $product->type || $product->type != $category->type || $productsColor->type != $category->type){

                        $this->checkTypes($category,$product,$productsColor,$request,$discount);

                    }else{
                        alert()->flash('ویرایش نشد', 'warning', [
                            'text' => 'چنین کالایی قبلا ثبت نشده، در صورت نیاز، ابتدا آن را ثبت کنید',
                            'showConfirmButton' => true,
                        ]);

                        return back();
                    }

                }
                if($productsColor->amount <= $request['amount']){
                    deleteSimple($productsColor);
                }else{
                    $productsColor->update([
                        'amount' => $productsColor->amount - $request['amount'],
                    ]);
                }
            }else{
                $productsColor->update([
                    'amount' => $request['amount'],
                    'base_sell_price' => $request['base_sell_price'],
                    'discount_sell_price' => $request['discount_sell_price'],
                    'discount' => $discount,
                    'priority' => $request['priority'],
                    'status' => $request['status']
                ]);
            }

        }

        $this->lessPriceUpdate($product);

        alert()->flash('ویرایش شد', 'success', [
            'text' => $productsColor->code . ' ویرایش شد',
            'showConfirmButton' => false,
            'timer' => 1500
        ]);

        return redirect(route('product.color.index',$product));

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param ProductsColor $productsColor
     * @return \Illuminate\Http\Response
     * @internal param ProductsColor $productsColor
     */
    public function destroy(ProductsColor $productsColor)
    {

        $product = $productsColor->Product()->first();

        deleteRecord($productsColor);

        $this->lessPriceUpdate($product);

        return redirect(route('product.color.index',$product));
    }

    //ajax baraye taarif rang dar data base
    protected function defineColor(Request $request)
    {

        $this->validate($request,[
            'colorName' => 'required|string|unique:color_store',
            'colorCode' => 'required|string|min:6|max:6'
        ]);

        ColorStore::create($request->all());

        alert()->flash('ثبت شد', 'success', [
            'text' => "رنگ با موفقیت ثبت شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);

        return redirect()->back();
    }

    //ajax baraye pak kardane range sabt shode dar mahsul az safe product info
    protected function deleteColor(Request $request){

        $productId = ProductsColor::whereId($request['productColorId'])->first()->product_id;
        $productInfo=Products::whereId($productId)->first();

        $request = $request->all();

        deleteSimple(ProductsColor::whereId($request['productColorId'])->first());

        $inventoryInfo = $productInfo->Inventory()->first();

        $productsColorInfo = $productInfo->productsColor()->get();

        $productColorNumber = 0;
        foreach($productsColorInfo as $productColor)
        {
            $productColorNumber += $productColor->amount;
        }

        $productsColorLimit = $inventoryInfo->stuff_number - $productColorNumber;

        $this->lessPriceUpdate($productInfo);

        return view('/CRM/Anbar/Product/productColor',compact('productInfo','productsColorLimit'));
    }

    protected function lessPriceUpdate($product){
        $max_base = ProductsColor::where('product_id', $product->id)->max('base_sell_price');
        $min_dis  = ProductsColor::where('product_id', $product->id)->min('discount_sell_price');

        if(!is_null($max_base)){
            $product->update([
                'base_sell_price'       => $max_base,
                'discount_sell_price'   => $min_dis
            ]);
        }

    }

    public function checkTypes($category,$product,$productsColor,$request,$discount){

        $product->type = $category->type;
        $product->save();

        $productsColor->type = $category->type;

        if(is_null($productsColor->size_id)){
            $size = $category->Size()->first();
            if(isset($size)){
                $productsColor->size_id = $size->id;
            }else{
                $size = Size::orderBy('code','desc')->first();
                if(isset($size)){
                    if(!is_null($size->code)){
                        $size->code++;
                        $code = $size->code;
                    } else{
                        $code = 'SAA111';
                    }
                }else{
                    $code = 'SAA111';
                }

                $size = Size::create([
                    'name'          => 'متوسط',
                    'category_id'   => $category->id,
                    'code'          => $code
                ]);
                $productsColor->size_id = $size->id;
            }
        }
        if(is_null($productsColor->color_id)){
            $color = ColorStore::orderBy('created_at','asc')->first();

            if(isset($color)){
                $productsColor->color_id = $color->id;
            }else{

                $color = ColorStore::create([
                    'name'          => 'سفید',
                    'colorCode'          => '#FFFFFF'
                ]);
                $productsColor->color_id = $color->id;
            }
        }
        $productsColor->update([
            'amount' => $productsColor->amount + $request['amount'],
            'base_sell_price' => $request['base_sell_price'],
            'discount_sell_price' => $request['discount_sell_price'],
            'discount' => $discount,
            'priority' => $request['priority'],
            'status' => $request['status']
        ]);
        $productsColor->save();
    }
}
