<?php

namespace App\Http\Controllers\Anbar;

use App\Models\ProductsColor;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class PriceChunkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $productColors = ProductsColor::get();

        if($productColors->isEmpty()){
            alert()->flash('توجه', 'info', [
                'text' => 'هنوز هیچ کالایی را در انبار ثبت نکرده اید، لطفا ابتدا کالاها را تعیین رنگ و سایز کرده و سپس به این بخش مراجعه کنید',
                'showConfirmButton' => true,
            ]);
            return redirect()->back();
        }

        return view('CRM.Anbar.PriceChunk.all',compact('productColors'));
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request = $request->all();

        unset($request['_token']);
        unset($request['sample_1_length']);

        foreach ($request as $inputs){
            foreach ($inputs as $input){
                $productColor = ProductsColor::whereId($input['id'])->first();

                $validator =  $this->validateInputs($productColor,$input);

                if ($validator->fails()) {
                    return redirect()->back()->withInput()->withErrors($validator->errors());
                }

                if($input['discount'] > $input['base']){
                    alert()->flash('خطا', 'error', [
                        'text' => 'قیمت فروش با تخفیف کالا با کد ' . $productColor->code . 'نمی تواند از قیمت فروش پایه بیشتر باشد',
                        'showConfirmButton' => true,
                    ]);
                    return redirect()->back();
                }
            }
        }

        foreach ($request as $inputs) {
            foreach ($inputs as $input) {
                $productColor = ProductsColor::whereId($input['id'])->first();

                if ($productColor->base_sell_price != $input['base'] || $productColor->discount_sell_price != $input['discount']){
                    $base_price     = $input['base'];
                    $discount_Price = Null;
                    $discount       = Null;

                    if(!empty($input['discount'])){
                        $discount_Price = $input['discount'];
                        $discount       = $base_price - $discount_Price;
                    }

                    $productColor->update([
                        'base_sell_price'       => $base_price,
                        'discount_sell_price'   => $discount_Price,
                        'discount'              => $discount
                    ]);

                    $this->lessPriceUpdate($productColor);
                }

            }
        }

        alert()->flash('بروزرسانی شد', 'success', [
            'text' => 'قیمت همه محصولات با موفقیت بروزرسانی شد',
            'showConfirmButton' => false,
            'timer' => 1500
        ]);

        return redirect()->back();

    }


    protected function lessPriceUpdate($productColor){

        $product = $productColor->Product()->first();

        $max_base = ProductsColor::where('product_id', $product->id)->max('base_sell_price');
        $min_dis  = ProductsColor::where('product_id', $product->id)->min('discount_sell_price');

        if(!is_null($max_base)){
            $product->update([
                'base_sell_price'       => $max_base,
                'discount_sell_price'   => $min_dis
            ]);
        }

    }

    protected function validateInputs($productColor , $input){
        $req = [
            'base_sell_price'       => $input['base'],
            'discount_sell_price'   => $input['discount'],
            'id'                    => $input['id']
        ];

        $rules = [
            'base_sell_price'       => 'required|integer|min:1000',
            'discount_sell_price'   => 'integer|min:1000',
            'id'                    => 'required|integer|min:1|exists:products_color,id',
        ];

        $messages = [
            'base_sell_price.required'      => 'فیلد قیمت فروش پایه با کد ' . $productColor->code. ' مورد نیاز است',
            'base_sell_price.integer'       => 'فیلد قیمت فروش پایه با کد ' . $productColor->code. ' باید نوع داده عددی باشد',
            'base_sell_price.min'           => 'فیلد قیمت فروش پایه با کد ' . $productColor->code. ' نباید کمتر از 1000 باشد',
            'discount_sell_price.required'  => 'فیلد قیمت فروش با تخفیف با کد ' . $productColor->code. ' مورد نیاز است',
            'discount_sell_price.integer'   => 'فیلد قیمت فروش  با تخفیف با کد ' . $productColor->code. ' باید نوع داده عددی باشد',
            'discount_sell_price.min'       => 'فیلد قیمت فروش  با تخفیف با کد ' . $productColor->code. ' نباید کمتر از 1000 باشد',
            'id.required'                   => 'فیلد شناسه با کد ' . $productColor->code. ' مورد نیاز است',
            'id.integer'                    => 'فیلد شناسه با کد ' . $productColor->code. ' باید نوع داده عددی باشد',
            'id.min'                        => 'فیلد شناسه با کد ' . $productColor->code. ' نباید کمتر از 1 باشد',
            'id.exists'                     => 'فیلد شناسه با کد ' . $productColor->code. ' وجود ندارد',
        ];

        $validator = Validator::make($req, $rules,$messages);

        return $validator;
    }

}
