<?php

namespace App\Http\Controllers\Anbar;
use App\Http\Controllers\Controller;

use App\Models\Products;
use App\Models\ProductsGallery;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Http\Request;
class ImageUploadController extends Controller
{

    protected function imageUpload(Request $request)
    {

        $this->validate($request, [
            'photo' => 'required|mimes:jpg,jpeg,png,bmp'
        ]);
        $file = $request->file('photo');


        $imagePath = '/app/images/';

//        File::exists(public_path($imagePath)) or File::makeDirectory(public_path($imagePath));


//-------------------big-----------------\

        $fileName1 = "img_or_".$request->id_product."_".str_random(5).time() . "." .$file->getClientOriginalExtension();


        $resize_filePath = public_path('/app/images/original/' . $fileName1);

        $resize_dirPath = '/app/images/original/';

        $this->resizeImage($file,$resize_dirPath,$resize_filePath,1024 , 1024,false);
//-------------------medium-----------------\

        $fileName2 = "img_me_".$request->id_product."_".str_random(5).time() . ".jpg" ;


        $resize_filePath = public_path('/app/images/medium/' . $fileName2);

        $resize_dirPath = '/app/images/medium/';

        $this->resizeImage($file,$resize_dirPath,$resize_filePath,400 , 400,false);
//---------------------thumb------------------------\\

        $fileName3 = "img_th_".$request->id_product."_".str_random(5).time() . ".jpg" ;

        $resize_filePath = public_path('/app/images/thumbnail/' . $fileName3);

        $resize_dirPath = '/app/images/thumbnail/';

        $this->resizeImage($file,$resize_dirPath,$resize_filePath,80 , 80,false);

//----------------original---------------------\

//        $file->move(public_path() . '/app/images/original/', $fileName1);


        $product = Products::whereId($request->id_product)->first();

        $product->productsGallery()->create([
            "image_path" => "/app/images/original/{$fileName1}",
            "image_path_m" => "/app/images/medium/{$fileName2}",
            "image_path_th" => "/app/images/thumbnail/{$fileName3}"
        ]);

        return view('/CRM/Anbar/Product/productImageGallery', compact('product'));

    }

    protected function deleteImage(Request $request)
    {
        $gallery = ProductsGallery::whereId($request['photoId'])->first();

        $product = $gallery->Product()->first();

        if(File::exists($gallery->originalPath()))
            File::delete($gallery->originalPath());

        if(File::exists($gallery->mediumPath()))
            File::delete($gallery->mediumPath());

        if(File::exists($gallery->thumbPath()))
            File::delete($gallery->thumbPath());

        deleteSimple($gallery);

        return view('/CRM/Anbar/Product/productImageGallery', compact('product'));
    }

    protected function pickBaseImage(Request $request)
    {
        $request = $request->all();
        $productId = $request['imageUrl']['title'];

        $product = Products::find($productId);

        if(!is_null($product->base_img_url) && !is_null($product->base_thumbnail_url)){
            $thumb_url = public_path(). $product->base_thumbnail_url;
            $meduim_url = public_path(). $product->base_medium_url;

            if(File::exists($thumb_url))
                File::delete($thumb_url);

            if(File::exists($meduim_url))
                File::delete($meduim_url);
        }

        $fileName = "img_".$productId."_".str_random(5).time() . ".jpg" ;


        $thumbFilepath = public_path('app/base_thumbnail/' . $fileName);
        $mediumFilepath = public_path('app/base_medium/' . $fileName);

        $thumbDirPath = '/app/base_thumbnail/';
        $mediumDirPath = '/app/base_medium/';

        $imageOrgUrl = $request['imageUrl']['content'];

        $imageUrl = parse_url($imageOrgUrl)['path'];


        $filePath = public_path().$imageUrl;

        $this->makeThumbnail($filePath,$thumbDirPath,$thumbFilepath,400 , 400);
        $this->makeThumbnail($filePath,$mediumDirPath,$mediumFilepath,800 , 800);

        $product->base_img_url = $imageUrl;
        $product->base_thumbnail_url = '/app/base_thumbnail/' . $fileName;
        $product->base_medium_url = '/app/base_medium/' . $fileName;

        $product->save();

        return view('/CRM/Anbar/Product/productImageGallery', compact('product'));

    }


    protected static function makeThumbnail($org_filePath, $resize_dirPath,$resize_filePath,$width, $height)
    {
//        File::exists(public_path($resize_dirPath)) or File::makeDirectory(public_path($resize_dirPath));
// open an image file
        $img = Image::make($org_filePath);

// now you are able to resize the instance
        $img->resize($width, $height);

//save image to resize_filePath
        $img->save($resize_filePath);

    }

    protected static function resizeImage($file, $resize_dirPath,$resize_filePath,$width, $height,$resize)
    {
//        File::exists(public_path($resize_dirPath)) or File::makeDirectory(public_path($resize_dirPath));
// open an image file
        $img = Image::make($file->getRealPath());

// now you are able to resize the instance
        if ($resize==true){
            $img->resize($width, $height);
        }
//save image to resize_filePath

        $img->save($resize_filePath);

    }

}
