<?php

namespace App\Http\Controllers\Anbar;

use App\Models\ColorStore;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali\jDate;

class ColorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $colors = ColorStore::latest()->get();
        $jdate = new jDate();
        return view('CRM.Anbar.color.all',compact('jdate','colors'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'colorName' => 'required|string|unique:color_store',
            'colorCode' => 'required|string|min:6|max:6'
        ]);

        ColorStore::create($request->all());

        alert()->flash('ثبت شد', 'success', [
            'text' => "رنگ با موفقیت ثبت شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);
        
        return redirect(route('color.index'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param ColorStore $color
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function edit(ColorStore $color)
    {
        return view('CRM.Anbar.color.edit',compact('color'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param ColorStore $color
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function update(Request $request, ColorStore $color)
    {
        $this->validate($request,[
            'colorName' => 'required|string|unique:color_store',
            'colorCode' => 'required|string|min:6|max:6'
        ]);

        $color->update($request->all());

        alert()->flash('ویرایش شد', 'success', [
            'text' => "رنگ با موفقیت ویرایش شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);
        
        return redirect(route('color.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param ColorStore $color
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function destroy(ColorStore $color)
    {
        deleteRecord($color);

        return redirect(route('color.index'));
    }
}
