<?php
namespace App\Http\Controllers\Anbar;

use App\Http\Controllers\Controller;
use App\Http\Requests\CategoryRequest;
use App\Models\Category;
use App\Models\StuffType;
use Illuminate\Http\Request;
use Morilog\Jalali\jDate;

class CategoryController extends Controller
{

    protected function index(){
        $categories = Category::latest()->get();
        $jdate = new jDate();

        $stuffTypes = StuffType::latest()->get();

        return view('/CRM/Anbar/Category/all',compact('stuffTypes','jdate','categories'));
    }

    protected function edit($categoryId){

        $category = Category::whereId($categoryId)->firstOrFail();
        $stuffTypes = StuffType::latest()->get();
            return view('CRM/Anbar/Category/edit',compact( 'stuffTypes','category') );

    }

    protected function store(CategoryRequest $request){

       $request = $request->all();

       Category::create([
           'category' => $request['category'],
           'stuffType_id' => $request['stuffType'],
           'type' => $request['type']
       ]);

        alert()->flash('ثبت شد', 'success', [
            'text' => "دسته بندی با موفقیت ثبت شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);


        return redirect(route('category.show'));

    }

    protected function update($categoryId,CategoryRequest $request){

        $request = $request->all();

       $category = Category::whereId($categoryId)->firstOrFail();

        $category->update([
            'category' => $request['category'],
            'stuffType_id' => $request['stuffType'],
            'type' => $request['type']
        ]);

        alert()->flash('ویرایش شد', 'success', [
            'text' => "دسته بندی با موفقیت ویرایش شد",
            'showConfirmButton' => false,
            'timer' => 1500
        ]);


        return redirect(route('category.show'));
    }

    protected function delete($categoryId){
        
        $categoryInfo = Category::whereId($categoryId)->firstOrFail();

        deleteRecord($categoryInfo);

        return redirect(route('category.show'));
    }


}
