<?php

namespace App\Http\Controllers\Anbar;

use App\Http\Controllers\Controller;
use App\Models\Brands;
use App\Http\Requests\BrandRequest;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    protected function index()
    {
        $items = $this->showItems();

        return (view('/CRM/Anbar/Brand/createBrand', compact('items')));
    }


    protected function editBrand($brandId)
    {

        $brand = new Brands();
        $brandInfo = $brand->whereraw("id = $brandId")->first();

        if (!empty($brandInfo)) {

            $brandName = $brandInfo['brandName'];
            return view('CRM/Anbar/Brand/editBrandDetail', compact('brandId', 'brandName'));

        } else {
            $message = "امکان ویرایش برند مورد نظر وجود ندارد.";
            $messageType = "failure";
            session()->flash('message', $message);
            session()->flash('messageType', $messageType);

            return (redirect('/CRM/Anbar/createBrand'));
        }

    }

    protected function addNewItem(BrandRequest $request)
    {
        $request = $request->all();
        unset($request['_token']);
        foreach ($request as $key => $value) {
            if (!is_null($value) && is_numeric($key)) {

                $Brand = new Brands();
                $Brand->updateOrCreate(['brandName' => $value]);

            }
        }
        $message = "برندهای مورد نظر با موفقیت تعریف شد";
        $messageType = "success";
        session()->flash('message', $message);
        session()->flash('messageType', $messageType);
        return (redirect('/CRM/createBrand'));

    }

    protected function saveEditBrand(BrandRequest $request)
    {

        $request = $request->all();
        unset($request['_token']);
        $brandId = $request['brandId'];
        $brandName = $request['brandName'];
        if (!is_null($brandName)) {
            $brand = new Brands();
            $brand->whereraw("id = '$brandId'")->update(["brandName" => $brandName]);
            $message = "برند با موفقیت ویرایش گردید";
            $messageType = "success";
            session()->flash('message', $message);
            session()->flash('messageType', $messageType);
            return (redirect('CRM/createBrand'));
        }

    }

    protected function deleteBrand($brandId)
    {

        $order = new Brands();
        $orderInfo = $order->whereraw("id =$brandId")->first();


        if (!empty($orderInfo)) {
            deleteRecord($orderInfo);
            return (redirect('CRM/createBrand'));
        } else {
            $message = "امکان حذف برند مورد نظر وجود ندارد.";
            $messageType = "failure";
            session()->flash('message', $message);
            session()->flash('messageType', $messageType);

            return (redirect('CRM/createBrand'));
        }


    }


    protected function showItems()
    {
        $Brand = new Brands();
        $Brand = $Brand->all();
        return ($Brand);
    }
}
