<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AdminUserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('public.Auth.userRegister');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {


    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'mobile' => ['required','digits:11','regex:/^(0)?(9[0-9]{9})$/','unique:users'],
            'password' => 'required|string|min:6|max:60|confirmed',
            'password_confirmation' => 'max:60|min:6',
            'fname' => ['required','max:60'],
            'lname' => ['required','max:60'],
            'melli_code' =>['required','digits:10','numeric'],
            'role' => ['required','string']
        ]);

        User::create([
            'mobile' => $request['mobile'],
            'password' => bcrypt($request['password']),
            'fname' => $request['fname'],
            'lname' => $request['lname'],
            'melli_code' => $request['melli_code'],
            'role'   => $request['role'],
            'confirmed' => 1,
        ]);

        alert()->flash('ثبت شد', 'success', [
            'text' => "حساب کاربری با موفقیت ثبت شد",
            'showConfirmButton' => false,
            'timer' => 1200
        ]);

        return redirect(route('admin.user.index'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
