<?php
namespace App\Helpers;

use App\Models\Products;
use Illuminate\Http\Request;

class Search
{

    public static function doSearch(Request $request){

        $filter = $request->all();

        if($request->has('tecInfo')){

            $tecInfos           = $request->input('tecInfo');
            $filter['tecInfo']  = array();
            $collections        = array();
            foreach ($tecInfos as $code => $tecIds){
                $filter['tecInfo']['key'] = $code;
                foreach ($tecIds as $tecId){
                    array_push($filter['tecInfo'],$tecId);
                }

                $collections[] = Products::filter($filter)->get();
                unset($filter['tecInfo']);
            }

            $i = 1;
            $products = null;
            foreach ($collections as $collection){
                if($i == 1 ){
                    $products = $collection;
                }else{
                    $products = $products->intersect($collection);
                }
                $i++;
            }

            $products = LAHelper::paginate($products,16,$request);

        }else{
            $products = Products::filter($request->all())->paginateFilter(16);
        }

        return $products;

    }

}