<?php


namespace App\Helpers;

use App\Models\ProductView;
use Request;
use App\Models\UserLog as LogActivityModel;
use App\Models\SearchLog;
use App\Models\SearchStatistic;

class LogActivity
{
    public static function addToLog($id)
    {
        $log = [];
        $log['product_id'] = $id;
        $log['url'] = Request::fullUrl();
        $log['method'] = Request::method();
        $log['ip'] = Request::ip();
        $log['agent'] = Request::header('user-agent');
        $log['user_id'] = auth()->check() ? auth()->user()->id : null;
        LogActivityModel::create($log);
    }
    public static function logActivityLists()
    {
        return LogActivityModel::latest()->paginate(20);
//        $LogActivity=LogActivity::where('deleted_at','=',NULL)->orderBy('id','desc')->paginate(10);
//        return $LogActivity;

    }


    public static function addToSearchLog($query,$category = 'all')
    {
        $log = [];
        $log['query'] = $query;
        $log['category'] = $category;
        $log['ip'] = Request::ip();
        $log['agent'] = Request::header('user-agent');
        $log['user_id'] = auth()->check() ? auth()->user()->id : null;
        SearchLog::create($log);

        if(!is_null($query)){
            $statistic = SearchStatistic::updateOrCreate(['query' => $query ]);
            $statistic->increment('count');
        }

    }

    public static function addToProductViewLog($product)
    {
        if(is_object($product)){
            $product = $product->id;
        }
        $log = [];
        $log['product_id'] = $product;
        $log['user_id'] = auth()->check() ? auth()->user()->id : null;
        $log['ip'] = Request::ip();
        $log['agent'] = Request::header('user-agent');

        ProductView::create($log);
    }
}