<?php

namespace App\Helpers;

use App\Models\DynamicMenuSlot;
use App\Models\ProductsTecInfo;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

class LAHelper
{


    // LAHelper::print_menu_editor($menu)
    public static function print_menu_editor($module,$menu,$status = 1) {

        $str = '<li class="dd-item dd3-item" data-id="'.$menu->id.'">
			<div class="dd-handle dd3-handle"></div>
			<div class="dd3-content"> '.$menu->tec_info_key.'</div>';

        $childrens = $module->where("parent_id", $menu->id)->where('status',$status)->orderBy('hierarchy', 'asc')->get();

        if(count($childrens) > 0) {
            $str .= '<ol class="dd-list">';
            foreach($childrens as $children) {
                $str .= LAHelper::print_menu_editor($module,$children);
            }
            $str .= '</ol>';
        }
        $str .= '</li>';
        return $str;
    }

    // LAHelper::print_menu($menu)
    public static function print_menu($module,$menu, $status = 1,$active = false) {
        $childrens = $module->where("parent_id", $menu->id)->where('status',$status)->orderBy('hierarchy', 'asc')->get();

        $treeview = "";
        $subviewSign = "";
        if(count($childrens)) {
            $treeview = " class=\"treeview\"";
            $subviewSign = '<i class="fa fa-angle-left pull-right"></i>';
        }
        $active_str = '';
        if($active) {
            $active_str = 'class="active"';
        }

        $str = '<li'.$treeview.' '.$active_str.'><a href="'.url(config("laraadmin.adminRoute") . '/' . $menu->url ) .'"> <span>'.$menu->tec_info_key.'</span> '.$subviewSign.'</a>';

        if(count($childrens)) {
            $str .= '<ul class="treeview-menu">';
            foreach($childrens as $children) {
                $str .= LAHelper::print_menu($module,$children);
            }
            $str .= '</ul>';
        }
        $str .= '</li>';
        return $str;
    }

    public static function print_tecs($product,$menu,$status = 1){
        $childrens = ProductsTecInfo::where("parent_id", $menu->id)->where('status',$status)->orderBy('hierarchy', 'asc')->get();
        $html = '<li class="tech-title"><i class="fa fa-caret-left"></i>'.$menu->tec_info_key.'</li>';
        if(count($childrens)) {
            foreach($childrens as $children) {
                $tecs = ProductsTecInfo::whereId($children->id)->where('status',$status)->first();
                $value = is_null($tecs->getProductTecValue($product)) ? null:$tecs->getProductTecValue($product)->value ;
                $html .= '<li>
                            <div class="moshakhasat-r">
                                <span>'.$tecs->tec_info_key.'</span>
                            </div>';
                if(isset($value)){
                    $value = nl2br($value);
                    $values = preg_split('/<br[^>]*>/i', $value);
                    $html .= '<ul>';
                    foreach ($values as $value){
                        if(!empty($value)){
                            $html .= '<li class="moshakhasat-l">
                                    <span class="pull-left">'.$value.'</span>
                                </li>';
                        }
                    }
                    $html .= '</ul>';
                }

                $html .= '</li>';
            }
        }
        return $html;
    }

    // LAHelper::print_menu_topnav($menu)
    public static function print_menu_topnav($module,$menu, $status = 1,$active = false) {
        $childrens = $module->where("parent_id", $menu->id)->where('status',$status)->orderBy('hierarchy', 'asc')->get();

        $treeview = "";
        $treeview2 = "";
        $subviewSign = "";
        if(count($childrens)) {
            $treeview = " class=\"dropdown\"";
            $treeview2 = " class=\"dropdown-toggle\" data-toggle=\"dropdown\"";
            $subviewSign = ' <span class="caret"></span>';
        }
        $active_str = '';
        if($active) {
            $active_str = 'class="active"';
        }

        $str = '<li '.$treeview.''.$active_str.'><a '.$treeview2.' href="'.url(config("laraadmin.adminRoute") . '/' . $menu->url ) .'">'.LAHelper::real_module_name($menu->tec_info_key).$subviewSign.'</a>';

        if(count($childrens)) {
            $str .= '<ul class="dropdown-menu" role="menu">';
            foreach($childrens as $children) {
                $str .= LAHelper::print_menu_topnav($module,$children);
            }
            $str .= '</ul>';
        }
        $str .= '</li>';
        return $str;
    }

    public static function randomId($table,$field_name)
    {

        $code = random_int(11111, 99999);

        $validator = Validator::make([$field_name => $code], [$field_name => "unique:$table"]);

        if ($validator->fails()) {
            self::randomId($table,$field_name);
        }

        return $code;
    }

    public static function paginate($items, $perPage, $request ,$setDefaultOption = true, $options = [])
    {
        if($setDefaultOption){
            $options = ['path' => $request->url(), 'query' => $request->query()];
        }
        $page = Input::get('page', 1); // Get the current page or default to 1


        $items = $items instanceof Collection ? $items : Collection::make($items);

        return new LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page, $options);
    }

    public static function uploadImage($file,$directory = 'default',$resize = true,$width = '', $height = '',$storage = false,$quality = 90){

        $fileName = time().'_'.rand(1111,9999). '.' . $file->getClientOriginalExtension();

        if($storage){
            if(!File::exists(storage_path('app/public/'.$directory))){
                File::makeDirectory(storage_path('app/public/'.$directory));
            }
            $resize_filePath = storage_path('app/public/'.$directory.'/'.$fileName);
            $public_path = '/storage/'.$directory.'/'. $fileName;

        }else{
            if(!File::exists(public_path('app/'.$directory))){
                File::makeDirectory(public_path('app/'.$directory));
            }
            $resize_filePath = public_path('app/'.$directory.'/'.$fileName);
            $public_path = '/app/'.$directory.'/'. $fileName;
        }

        $img = Image::make($file->getRealPath());

        if($resize){
            $img->resize($width, $height);
        }
        $img->save($resize_filePath,$quality);

        return $public_path;

    }

    public static function getFrontMenu(){
        return DynamicMenuSlot::where('status',1)->orderBy('menu_slot_name','asc')->get();
    }

    public static function getFrontSubMenu($menu){

        return $menu->DynamicSubMenu()->where('status',1)->orderBy('priority','asc')->get();
    }

}
