<?php
namespace App\Helpers;

use App\Models\Brands;
use App\Models\ColorStore;
use App\Models\ProductsTecInfo;
use App\Models\TecInfoProduct;

trait Choices
{
    protected function choicesMade($type, $id, $tec = null)
    {
        $session2 = session('choices');
        if ($type == 'brand') {
            $brand = Brands::whereId($id)->first();
            if (isset($brand)) {
                $html = $brand->brandName;
                $filter = 'brand[' . $id . ']=' . $id;
                if (isset($session2)) {
                    if (!searchArray($session2, $html, (string)$filter)) {
                        $array = session()->get('choices', []);
                        $array[$html] = $filter;

                        session()->put('choices', $array);
                    }
                } else {
                    $choice[$html] = $filter;
                    session()->put('choices', $choice);
                }
            }
        } elseif ($type == 'status') {
            $html = 'فقط کالاهای موجود';
            $filter = 'status=1';
            if (isset($session2)) {
                if (!searchArray($session2, $html, (string)$filter)) {
                    $array = session()->get('choices', []);

                    $array[$html] = $filter;

                    session()->put('choices', $array);
                }
            } else {
                $choice[$html] = $filter;
                session()->put('choices', $choice);
            }
        } elseif ($type == 'color') {
            $color = ColorStore::whereId($id)->first();
            if (isset($color)) {
                $html = $color->colorName;
                $filter = 'color[' . $id . ']=' . $id;
                if (isset($session2)) {
                    if (!searchArray($session2, $html, (string)$filter)) {
                        $array = session()->get('choices', []);
                        $array[$html] = $filter;
                        session()->put('choices', $array);
                    }
                } else {
                    $choice[$html] = $filter;
                    session()->put('choices', $choice);
                }
            }
        } elseif ($type == 'tecInfo') {
            if (isset($tec)) {
                $tecInfo_code = ProductsTecInfo::whereCode($id)->first();
                $tecInfo_id = TecInfoProduct::where('tec_id',$tec)->first();
                $html = $tecInfo_code->tec_info_key.':'.$tecInfo_id->value;
                $filter = 'tecInfo['. $id.']['.$tec .']='. $tec;
                if (isset($session2)) {
                    if (!searchArray($session2, $html, (string)$filter)) {
                        $array = session()->get('choices', []);
                        $array[$html] = $filter;
                        session()->put('choices', $array);
                    }
                } else {
                    $choice[$html] = $filter;
                    session()->put('choices', $choice);
                }
            }
        }
    }

    protected function choicesMadePrice($price, $cat)
    {
        $price2 = explode(',', $price);

        $price_range = $this->priceRange($cat);

        $price_range['min'] = number_format($price_range['min'], 0, ".", null);
        $price_range['max'] = number_format($price_range['max'], 0, ".", null);
        reset($price2);
        if (current($price2) == $price_range['min'] && next($price2) == $price_range['max']) {
            $html = 'از ' . priceFormat($price_range['min']) . ' تا ' . priceFormat($price_range['max']) . ' تومان';
            session()->forget('choices.' . $html);
        } else {
            $html = 'از ' . priceFormat(current($price2)) . ' تا ' . priceFormat(next($price2)) . ' تومان';
            $session2 = session('choices');
            $filter = 'price=' . $price;
            if (isset($session2)) {
                if (!searchArray($session2, $html, (string)$filter)) {

                    $array = session()->get('choices', []);

                    $array[$html] = $filter;

                    session()->put('choices', $array);
                }
            } else {
                $choice[$html] = $filter;
                session()->put('choices', $choice);
            }

        }
    }
}