<?php

namespace App\Events;

use App\Models\Payment;
use App\Models\PostLog;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;

class PurchaseSendByPostEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $payment;
    public $post;

    /**
     * Create a new event instance.
     *
     * @param Payment $payment
     * @param PostLog $postLog
     */
    public function __construct(Payment $payment,PostLog $postLog)
    {
        $this->payment = $payment;
        $this->post = $postLog;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
