<?php

namespace App\Events;

use App\Models\Cart;
use App\Models\CartProduct;
use App\Models\Inventory;
use App\Models\Products;
use App\Models\ProductsColor;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class ProfitEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $cart;
    public $cartProduct;
    public $product;
    public $cartProducts;

    /**
     * Create a new event instance.
     *
     * @param Cart $cart
     * @param $cartProducts
     * @param CartProduct $cartProduct
     * @param Products $products
     * @internal param Products $product
     * @internal param ProductsColor $productColor
     */
    public function __construct(Cart $cart,$cartProducts,CartProduct $cartProduct,Products $products)
    {
        $this->cart = $cart;
        $this->cartProduct = $cartProduct;
        $this->product = $products;
        $this->cartProducts = $cartProducts;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
