<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use TeamTNT\TNTSearch\TNTSearch;

class IndexProductsCategory extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'index:products-category';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'category index';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $tnt = new TNTSearch;

        $this->get_search_config($tnt);

        $indexer = $tnt->createIndex('category.index');
        $indexer->query('SELECT id, category_id FROM products;');
        $indexer->run();
    }

    protected function get_search_config($tnt)
    {

        $driver = config('database.default');
        $config = config('scout.tntsearch') + config("database.connections.{$driver}");

        return $tnt->loadConfig($config);

    }
}
